﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private ClassBL _ClassBL = null;

        public ClassBL Class
        {
            get
            {
                if (_ClassBL == null)
                {
                    _ClassBL = new ClassBL(this);
                }

                return _ClassBL;
            }
        }

        public class ClassBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>, Gemini.Core.BL.Interface.IBORestoreByID
        {
            public ClassBL(ZSBELearning BL) : base(BL) { }

            public int Count()
            {
                return BLP.DAL.Class.Count();
            }

            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.EvaluationSheet_Class.Delete();
                    BLP.DAL.CompetencePart_Class.Delete();
                    BLP.DAL.Class.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public List<BO.Class> Restore()
            {
                return BLP.DAL.Class.Restore();
            }

            public List<BO.Class> Restore(BO.Instructor Instructor)
            {
                ELearning.BL.BO.Class.Search _search = new BO.Class.Search();
                _search.InstructorID = Instructor.ID;
                return BLP.DAL.Class.Restore(_search);
            }

            public List<BO.Class> Restore(BO.School School)
            {
                ELearning.BL.BO.Class.Search _search = new BO.Class.Search();
                _search.SchoolID = School.ID;
                return BLP.DAL.Class.Restore(_search);
            }

            public List<BO.Class> Restore(BO.SchoolYear SchoolYear)
            {
                ELearning.BL.BO.Class.Search _search = new BO.Class.Search();
                _search.SchoolYearID = SchoolYear.ID;
                return BLP.DAL.Class.Restore(_search);
            }
            
            public List<BO.Class> Restore(ELearning.BL.BO.Class.Search Search)
            {
                return BLP.DAL.Class.Restore(Search);
            }

            public BO.Class RestoreById(long? ID)
            {
                BO.Class _class = null;
                if (ID.HasValue)
                {
                    _class = BLP.DAL.Class.Restore(ID);
                }
                return _class;
            }

            public BO.Class Restore(BO.Student Student)
            {
                BO.Class _class = null;
                if (Student != null)
                {
                    _class = RestoreById(Student.ClassID);
                }
                return _class;
            }            

            public Gemini.Core.BL.Base.MethodResult Save(BO.Class Class)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    if (Class == null)
                    {
                        _methodResult.SetSuccess = false;
                    }
                    else
                    {
                        BO.SchoolYear _activeSchoolYear = BLP.SchoolYear.RestoreActive();
                        if (_activeSchoolYear != null)
                        {
                            ELearning.BL.BO.Class.Search _search = new BO.Class.Search();
                            _search.Name = Class.Name;
                            _search.SchoolYearID = _activeSchoolYear.ID;

                            BO.Class _nameClass = BLP.DAL.Class.RestoreTopOne(_search);
                            if ((_nameClass != null) && (_nameClass.ID != Class.ID))
                            {
                                _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Class.NameAlreadyExist.Value, _nameClass.Name), false);
                            }
                            else
                            {
                                if (Class.ID.HasValue)
                                {
                                    #region Update
                                    _methodResult.SetSuccess = BLP.DAL.Class.Update(Class);

                                    if (_methodResult.Success)
                                    {
                                        BLP.APIEduFarma.SyncClassSave(Class);
                                    }
                                    #endregion
                                }
                                else
                                {
                                    #region Create
                                    Class.SchoolYearID = _activeSchoolYear.ID;
                                    _methodResult.SetSuccess = BLP.DAL.Class.Create(Class);

                                    if (_methodResult.Success)
                                    {
                                        BLP.APIEduFarma.SyncClassAdd(Class);
                                        _methodResult.Add(BLP.EvaluationSheet.Class.Create(Class));
                                        _methodResult.Add(BLP.CompetencePart.Class.Create(Class));
                                    }
                                    #endregion
                                }
                            }
                        }
                        else
                        {
                            _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Class.SaveFailed.Value, Class.DisplayValue), false);
                        }
                    }
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Class.SaveFailed.Value, Class.DisplayValue), _exception);
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.Class Class)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (Class != null)
                {
                    try
                    {
                        _methodResult.SetSuccess = BLP.DAL.Class.Remove(Class);

                        if (_methodResult.Success)
                        {
                            _methodResult.Add(BLP.EvaluationSheet.Class.Remove(Class));
                            _methodResult.Add(BLP.CompetencePart.Class.Remove(Class));
                            BLP.APIEduFarma.SyncClassDelete(Class);
                        }
                        else
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Failed.Value, false);
                        }
                    }
                    catch (Exception _exeption)
                    {
                        _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Class.RemoveFailed.Value, Class.Name), _exeption);
                    }
                }
                return _methodResult;
            }

            public BO.Class New()
            {
                return BLP.DAL.Class.New();
            }

            public int Count(BO.School School)
            {
                ELearning.BL.BO.Class.Search _search = new BO.Class.Search();
                _search.SchoolID = School.ID;
                return BLP.DAL.Class.Count(_search);
            }

            public int Count(BO.Instructor Instructor)
            {
                ELearning.BL.BO.Class.Search _search = new BO.Class.Search();
                _search.InstructorID = Instructor.ID;
                return BLP.DAL.Class.Count(_search);
            }

            private ViewBL _view = null;

            public ViewBL View
            {
                get
                {
                    if (_view == null)
                    {
                        _view = new ViewBL(this.BLP);
                    }
                    return _view;
                }
            }

            public class ViewBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>, Gemini.Core.BL.Interface.IBORestoreByID
            {
                public ViewBL(ZSBELearning BL) : base(BL) { }

                public List<BO.View.Class> Restore(BO.Class.Search Search)
                {
                    return BLP.DAL.ClassView.Restore(Search);
                }

                public Gemini.Core.BL.Interface.BO.IBaseUnique<long?> RestoreByID(long? ID)
                {
                    return BLP.DAL.ClassView.Restore(ID);
                }

                public BO.View.Class Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
                {
                    return BLP.DAL.ClassView.Restore(BO.ID);
                }

                public BO.View.Class RestoreById(long? ID)
                {
                    return BLP.DAL.ClassView.Restore(ID);
                }
            }

            Gemini.Core.BL.Interface.BO.IBaseUnique<long?> Gemini.Core.BL.Interface.IBORestoreByID.RestoreByID(long? ID)
            {
                return RestoreById(ID);
            }
        }
    }
}